/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class MagicProtectionModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> MAGIC_DATA = TConstruct.createKey("magic_protection");

    public MagicProtectionModifier() {
        super(MAGIC_DATA);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PotionEvent.PotionAddedEvent.class, MagicProtectionModifier::onPotionStart);
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (!source.m_19379_() && !source.m_19378_() && source.m_19387_()) {
            modifierValue += this.getScaledLevel(tool, level) * 2.5f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.5f, tooltip);
    }

    @Override
    protected ModifierMaxLevel createData() {
        return new ModifierMaxLevel();
    }

    private static void onPotionStart(PotionEvent.PotionAddedEvent event) {
        MobEffectInstance newEffect = event.getPotionEffect();
        if (!newEffect.m_19544_().m_19486_() && !newEffect.getCurativeItems().isEmpty()) {
            LivingEntity living = event.getEntityLiving();
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                float max;
                ModifierMaxLevel magicData = data.get(MAGIC_DATA);
                if (magicData != null && (max = magicData.getMax()) > 0.0f) {
                    int duration = (int)((float)newEffect.m_19557_() * (1.0f - max * 0.05f));
                    if (duration < 0) {
                        duration = 0;
                    }
                    newEffect.f_19503_ = duration;
                }
            });
        }
    }
}

